********************************************************************************
clear all
set more off
cd "C:\Users\Thomas.Pellet\OneDrive - Peterson Institute for International Economics\2017-11\JEP OB paper natural rate\Figure 3a"

********************************************************************************
********************************************************************************
							*4-year Window
********************************************************************************
********************************************************************************
*-------------------------------------------------------------------------------
*
*					Merge Finaldata_c225_new with prime age unemployment
*
*-------------------------------------------------------------------------------
cd "C:\Users\Thomas.Pellet\OneDrive - Peterson Institute for International Economics\2017-11\JEP OB paper natural rate\Figure 3a"
use "FinalData_c225_new.dta" 

merge 1:1 Country date using "prime age unemployment.dta", keep(master match)

save "FinalData_c225_new_prime.dta"
********************************************************************************
// 1. Generate Recession Episodes	
********************************************************************************

use FinalData_c225_new_prime.dta, clear 

keep if lngdp!=. & lnemp!=. & lnprod!=. 
drop lrgdp_point
drop if ifscode==196

********************************************************************************
*Generate quadratic trend by Country
********************************************************************************

sort ifscode date

gen datesq = date^2
gen coeff_a =.
gen coeff_b = .
gen cons=.
gen trend=.

levelsof ifscode, local(codes)

foreach i in `codes' {
reg lrgdp date datesq if ifscode==`i'

replace coeff_a = _b[date] if ifscode==`i'
replace coeff_b = _b[datesq] if ifscode==`i'
replace cons= _b[_cons] if ifscode==`i'

replace trend = coeff_a * date + coeff_b * datesq + cons if ifscode==`i'
}
********************************************************************************

run sbbq.do
gen extremum=.
levelsof ifscode, local(codes)
foreach i in `codes' {
sbbq lngdp if ifscode==`i'
replace extremum = lngdp_point if ifscode==`i'
drop lngdp_point
}

preserve
drop extremum
save Data_prov.dta, replace
restore

drop if extremum==0

*for each ifscode we should start with a peak and finish with a trough (we are only interested in recessions), remove trough at the beginning and peaks at the end
forval i=1/20 {
sort ifscode date
by ifscode: gen n1=_n
by ifscode: gen n2=_N
by ifscode: replace extremum=0 if n1==1 & extremum==-1 
by ifscode: replace extremum=0 if n1==n2 & extremum==1 
drop if extremum==0 
drop n1 n2 
}

save Data_prov_bis.dta, replace

use Data_prov.dta, clear
merge m:1 date ifscode using Data_prov_bis.dta, keepusing(extremum) nogen
replace extremum=0 if extremum==.

gen lrgdp_point=extremum
gen lngdp_point=extremum

sort ifscode date

save FinalData_c225_new_primebis.dta, replace 

sort Country date
keep ifscode Country date sdate lrgdp lrgdp_point extremum primeurate
keep if lrgdp_point!=0

	// Generate Dates for Peaks, Troughs, and Duration
	// Peaks
by Country: gen speak = sdate if lrgdp_point==1
by Country: gen strough = sdate[_n+1] if lrgdp_point==1
by Country: gen peak = date if lrgdp_point==1
by Country: gen trough = date[_n+1] if lrgdp_point==1
by Country: gen peak_gdp = lrgdp if lrgdp_point==1
by Country: gen trough_gdp = lrgdp[_n+1] if lrgdp_point==1
format peak trough %tq

	// Duration 
gen lrgdp_duration = trough - peak + 1

	// Troughs
foreach var of varlist speak strough peak trough peak_gdp trough_gdp lrgdp_duration {
replace `var' = `var'[_n-1] if lrgdp_point==-1
}
	// Generate Episodes (Country-Peak-Trough)
gen episode = Country + "-" + speak + "-" + strough
gen false_episode = trough_gdp > peak_gdp
gen drop_episode = .

	// Check false episode
tab episode if false_episode==1
tab episode if drop_episode==1

	// Save False Episodes
preserve
keep if false_episode==1 | drop_episode==1
drop if lrgdp_point==-1
keep ifscode date Country
save FinalData_episode_false_and_drop.dta, replace
restore

	// Save Recession Episodes 
drop if lrgdp_point==-1
drop if false_episode==1
drop if drop_episode==1
drop lrgdp lrgdp_point sdate speak strough peak_gdp trough_gdp false_episode drop_episode // peak through


gen included=.
replace included=0 if peak<4*4+8+1
replace included=0 if trough>225-4*7
drop if included==0
drop included


	// Drop Episodes too close to 1960 (can't estimate trend) or 2015 (can't estimate output gap)
preserve
keep episode peak trough
gen included=1
********************************************************************************
********************************************************************************

*ADJUSTWINDOW
replace included=0 if peak<4*4+8+1
replace included=0 if trough>225-4*7
drop peak trough
save Episode_Included.dta, replace
restore

preserve
keep episode Country peak trough ifscode lrgdp_duration
********************************************************************************

*ADJUSTWINDOW
drop if peak<4*4+8+1  
drop if trough>225-4*7

by Country: gen episodeid = _n
drop Country
save Episode_id.dta, replace
restore

drop peak trough

preserve
egen X = count(ifscode) // total number of recessions
by Country: egen Y = count(ifscode) 
egen YY = max(Y) // max recessions by country
save numbers.dta, replace

use FinalData_c225_new_primebis.dta, clear
merge 1:1 ifscode date using numbers.dta, keepusing(X YY) nogen
egen XX=mean(X)
egen Y=mean(YY)
drop X
drop YY
gen X = XX
gen YY = Y
drop XX
drop Y
save FinalData_c225_new_primebis.dta, replace
restore

egen X = count(ifscode) // total number of recessions
by Country: egen Y = count(ifscode) 
egen YY = max(Y) // max recessions by country


	// Expand each peak (as many lines as duration)
preserve
expand lrgdp_duration
sort episode
by episode: replace date = date + _n - 1

	// Dummy Recession
gen recession = 1
save FinalData_episode_recession.dta, replace
restore


********************************************************************************

	** Note1: expand each episode 150 times, and make the peak at epid=100
	** there are about 50 quarters before the peak and 100 quarters after the peak
expand 150
sort episode date
by episode: gen epid = _n
replace date = date - epid + 100

merge m:1 ifscode date using FinalData_c225_new_primebis.dta, keepusing(sdate year unemp Distress CPI rgdp lrgdp lrgdppc agrgdp qgrgdp creditboom systemic lngdp lnemp lnprod trend lnwap lnlfp lnemprate primeurate)
drop if _m==2
drop _m

merge m:1 ifscode date using FinalData_episode_recession.dta, keepusing(recession lrgdp_duration) nogen
sort episode date
replace recession = 0 if recession==.

gen episode_recession = substr(episode, -13,6)<=sdate & substr(episode, -6,6)>=sdate


********************************************************************************
// 2. By Episode Generate Dummies Types recession
********************************************************************************

gen before_recession_forCPI = (episode_recession[_n+1]==1|episode_recession[_n+2]==1|episode_recession[_n+3]==1|episode_recession[_n+4]==1) & episode_recession==0

by episode: egen MaxDistress = max(Distress*(episode_recession==1))
gen Type_Distress = 0 if MaxDistress==0
replace Type_Distress = 1 if MaxDistress>=1

by episode: egen MaxSystemic = max(systemic*(episode_recession==1)) // For financial crisis
gen Type_Systemic = 0 if MaxSystemic==0 | MaxSystemic==.
replace Type_Systemic = 1 if MaxSystemic==1

by episode: gen CPI_ych = 100*(CPI / CPI[_n-4] - 1)
by episode: egen ave_CPI_ych = mean(CPI_ych*(episode_recession==1))
by episode: egen bef_CPI_ych = mean(CPI_ych*(before_recession_forCPI==1))
gen Type_Inflation = 1 if ave_CPI_ych > bef_CPI_ych
replace Type_Inflation = 0 if ave_CPI_ych <= bef_CPI_ych


by episode: gen Oilprice = 1 if (year>=1974&year<=1976)|(year>=1979&year<=1982)
by episode: egen MaxOilprice = max(Oilprice*(episode_recession==1))
gen Type_Oilprice = 1 if MaxOilprice == 1
replace Type_Oilprice = 0 if Type_Oilprice==.

preserve
keep if epid==100
keep episode lrgdp_duration Type_Distress Type_Systemic Type_Inflation Type_Oilprice 
gen lgdp_duration = lrgdp_duration - 1
merge 1:1 episode using Typesofrecession_new_temp.dta, nogen  // This file is the table from the BCS online appendix
save Type_recession.dta, replace
restore



********************************************************************************

merge m:1 episode using Type_recession.dta, keepusing(intentionaldisinflation)

keep Country date ifscode episode epid recession episode_recession lrgdp_duration intentionaldisinflation CPI_ych

keep if intentionaldisinflation==1

merge m:1 date ifscode using FinalData_c225_new_prime.dta, keepusing(primeurate)
drop if _m!=3
drop _merge

sort episode date

save FinalData_c225_new_prime_primeuratedisinfl.dta, replace 

********************************************************************************

clear all
set more off
cd "C:\Users\Thomas.Pellet\OneDrive - Peterson Institute for International Economics\2017-11\JEP OB paper natural rate\Figure 3a"

use FinalData_c225_new_prime_primeuratedisinfl.dta, clear 

by episode: gen CPI_ych_temp = CPI_ych - CPI_ych[_n-1]
drop CPI_ych
gen CPI_ych=CPI_ych_temp
drop CPI_ych_temp

levelsof episode, local(codes)

forval nw = 4/10 {

scalar window=`nw'

gen meanprimeurate_trend`nw'=.
gen meanprimeurate_trend`nw'_bis =.

*gen meaninfl_trend`nw'=.
*gen meaninfl_trend`nw'_bis =.

foreach i in `codes' {
egen meanprimeurate_trend`nw'_temp = mean(primeurate) if epid>=108 & epid<108+4*window & episode=="`i'"
replace meanprimeurate_trend`nw'=meanprimeurate_trend`nw'_temp if episode=="`i'"
drop meanprimeurate_trend`nw'_temp

egen meanprimeurate_trend`nw'_temp = mean(meanprimeurate_trend`nw') if episode=="`i'"
replace meanprimeurate_trend`nw'_bis = meanprimeurate_trend`nw'_temp if episode=="`i'"
drop meanprimeurate_trend`nw'_temp

replace meanprimeurate_trend`nw'=meanprimeurate_trend`nw'_bis if episode=="`i'"

/*
egen meaninfl_trend`nw'_temp = mean(CPI_ych) if epid>=108 & epid<108+4*window & episode=="`i'"
replace meaninfl_trend`nw'=meaninfl_trend`nw'_temp if episode=="`i'"
drop meaninfl_trend`nw'_temp

egen meaninfl_trend`nw'_temp = mean(meaninfl_trend`nw') if episode=="`i'"
replace meaninfl_trend`nw'_bis = meaninfl_trend`nw'_temp if episode=="`i'"
drop meaninfl_trend`nw'_temp

replace meaninfl_trend`nw'=meaninfl_trend`nw'_bis if episode=="`i'"
*/
}

drop meanprimeurate_trend`nw'_bis
*drop meaninfl_trend`nw'_bis

}


forval ns = 3/10 {

scalar wstart=`ns'
scalar wend=4+`ns' 

gen meanprimeurate_gap`ns'=.
gen meanprimeurate_gap`ns'_bis =.

*gen meaninfl_gap`ns'=.
*gen meaninfl_gap`ns'_bis =.

foreach i in `codes' {
egen meanprimeurate_gap`ns'_temp = mean(primeurate) if epid<=100-(lrgdp_duration-1)-4*wstart & epid>=100-(lrgdp_duration-1)-4*wend & episode=="`i'"
replace meanprimeurate_gap`ns'=meanprimeurate_gap`ns'_temp if episode=="`i'"
drop meanprimeurate_gap`ns'_temp

egen meanprimeurate_gap`ns'_temp = mean(meanprimeurate_gap`ns') if episode=="`i'"
replace meanprimeurate_gap`ns'_bis = meanprimeurate_gap`ns'_temp if episode=="`i'"
drop meanprimeurate_gap`ns'_temp

replace meanprimeurate_gap`ns'=meanprimeurate_gap`ns'_bis if episode=="`i'"


/*
egen meaninfl_gap`ns'_temp = mean(CPI_ych) if epid<=100-(lrgdp_duration-1)-4*wstart & epid>100-(lrgdp_duration-1)-4*wend & episode=="`i'"
replace meaninfl_gap`ns'=meaninfl_gap`ns'_temp if episode=="`i'"
drop meaninfl_gap`ns'_temp

egen meaninfl_gap`ns'_temp = mean(meaninfl_gap`ns') if episode=="`i'"
replace meaninfl_gap`ns'_bis = meaninfl_gap`ns'_temp if episode=="`i'"
drop meaninfl_gap`ns'_temp

replace meaninfl_gap`ns'=meaninfl_gap`ns'_bis if episode=="`i'"
*/
}

drop meanprimeurate_gap`ns'_bis
*drop meaninfl_gap`ns'_bis
}


forval nw = 4/10 {
forval ns = 3/10 {

gen primeurategap_w`nw'_s`ns'= meanprimeurate_gap`ns' - meanprimeurate_trend`nw'
*gen inflgap_w`nw'_s`ns'= meaninfl_gap`ns' - meaninfl_trend`nw'

}
}


save primeurategapdisinfl_all.dta, replace


keep if epid==100
drop in 8
drop in 15

drop Country date ifscode lrgdp_duration epid recession episode_recession primeurate CPI_ych

save primeurategapdisinfl.dta, replace

use "C:\Users\Thomas.Pellet\OneDrive - Peterson Institute for International Economics\2017-11\JEP OB paper natural rate\Figure 3a"

gen epidbis=100-epid

sort Country episode date
gen recessionbis=20 if recession==1
gen postrecession=20 if epid<=100-(lrgdp_duration-1)-4*3 & epid>=100-(lrgdp_duration-1)-4*7
replace recessionbis=0 if recessionbis==.

twoway (area recessionbis epidbis, bcolor(gs15)) (area postrecession epidbis, bcolor(gs11)) (line primeurate epidbis) if epidbis<60&epidbis>-40, by(episode) xline(0)


erase Data_prov.dta
erase Data_prov_bis.dta
erase Episode_id.dta
erase Episode_Included.dta
erase FinalData_c225_new_primebis.dta
erase FinalData_episode_false_and_drop.dta
erase FinalData_episode_recession.dta
erase numbers.dta
erase Type_recession.dta



